function [countDecisionsLeftBiased, countLeftChosenLeftBiased, ...
    countDecisionsRightBiased, countLeftChosenRightBiased] = ...
    ChoicesGroupedByBiasedAndRank(valueDiffs, parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));
fclose('all');

countDecisionsLeftBiased = cell(3,1);
countLeftChosenLeftBiased = cell(3,1);
countDecisionsRightBiased = cell(3,1);
countLeftChosenRightBiased = cell(3,1);
for i=1:3
    countDecisionsLeftBiased{i} = zeros(length(valueDiffs), 1);
    countLeftChosenLeftBiased{i} = zeros(length(valueDiffs), 1);
    countDecisionsRightBiased{i} = zeros(length(valueDiffs), 1);
    countLeftChosenRightBiased{i} = zeros(length(valueDiffs), 1);
end

valueDiff = [];
biased = [];
timeDiff = [];
choice = [];
for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        if data.testTotalFixTime{numBlock}(numTrial) >= 3
            continue;
        end
        timeLeft = data.testFixTimeLeft{numBlock}(numTrial);
        timeRight = data.testFixTimeRight{numBlock}(numTrial);
        if data.biasedItem{numBlock}(numTrial) == 1
%             if timeRight >= timeLeft
%                 continue;
%             end
            timeDiff = [timeDiff; timeLeft - timeRight];
        elseif data.biasedItem{numBlock}(numTrial) == 2
%             if timeLeft >= timeRight
%                 continue;
%             end
        	timeDiff = [timeDiff; timeRight - timeLeft];
        end

        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        valueDiff = [valueDiff; valueLeft - valueRight];
        biased = [biased; data.biasedItem{numBlock}(numTrial)];
        choice = [choice; data.testResponseType{numBlock}(numTrial)];
    end
end

ranks = tiedrank(timeDiff) / length(timeDiff);
[~,idx] = sort(ranks);
sortedTimeDiff = timeDiff(idx);
thresh1 = sortedTimeDiff(ceil(((length(sortedTimeDiff)/3) * 2)));
thresh2 = sortedTimeDiff(ceil((length(sortedTimeDiff)/3)));

for i=1:length(valueDiff)
    if timeDiff(i) >= thresh1
        r = 1;
    elseif timeDiff(i) <= thresh2
        r = 3;
    else
        r = 2;
    end
    idx = find(valueDiffs==valueDiff(i));

    % Left was biased.
    if biased(i) == 1
        countDecisionsLeftBiased{r}(idx) = ...
            countDecisionsLeftBiased{r}(idx) + 1;
        if choice(i) == -1 % chose left
            countLeftChosenLeftBiased{r}(idx) = ...
                countLeftChosenLeftBiased{r}(idx) + 1;
        end
    % Right was biased.
    elseif biased(i) == 2
        countDecisionsRightBiased{r}(idx) = ...
            countDecisionsRightBiased{r}(idx) + 1;
        if choice(i) == -1 % chose left
            countLeftChosenRightBiased{r}(idx) = ...
                countLeftChosenRightBiased{r}(idx) + 1;
        end
    end
end
end
