function [leftCountDecisions, leftCountLeftChosen, rightCountDecisions, ...
    rightCountLeftChosen] = ChoicesGroupedByFirstFixation(valueDiffs, ...
    parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));

% Load eye tracking data.
[~, ~, ~, item, ~] = ReadEyetrackingData(parcode, session);

leftCountDecisions = zeros(length(valueDiffs), 1);
leftCountLeftChosen = zeros(length(valueDiffs), 1);
rightCountDecisions = zeros(length(valueDiffs), 1);
rightCountLeftChosen = zeros(length(valueDiffs), 1);

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        if data.testTotalFixTime{numBlock}(numTrial) >= 3
            continue;
        end
        
        distLeft = angTarget - data.left{numBlock}(numTrial);
        distRight = angTarget - data.right{numBlock}(numTrial);
        valueLeft = - abs(distLeft);
        valueRight = - abs(distRight);
        valueDiff = valueLeft - valueRight;
        idx = find(valueDiffs==valueDiff);

        choice = data.testResponseType{numBlock}(numTrial);
        fixItem = item{numBlock,numTrial};

        % Iterate over fixations.
        for i = 1:length(fixItem)
            if fixItem(i) == 1 % first item is LEFT
                leftCountDecisions(idx) = leftCountDecisions(idx) + 1;
                if choice == -1
                    leftCountLeftChosen(idx) = ...
                        leftCountLeftChosen(idx) + 1;
                end
                break;
            elseif fixItem(i) == 2 % first item is RIGHT
                rightCountDecisions(idx) = rightCountDecisions(idx) + 1;
                if choice == -1
                    rightCountLeftChosen(idx) = ...
                        rightCountLeftChosen(idx) + 1;
                end
                break;
            end
        end
    end
end
end
