function corrProbs = CorrProbChooseLeftVsTimeAdvantageLeft(timeBins, ...
    valueDiffs, avgProbs, choice, fixItem, fixTime, valueLeft, ...
    valueRight, parcodes, sessions, oddTrialsOnly, evenTrialsOnly, ...
    excludeByTimeLimit)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end
if ~exist('excludeByTimeLimit', 'var')
    excludeByTimeLimit = false;
end

if exist('parcodes', 'var') && exist('sessions', 'var')
    trial = 1;
    for p=1:size(parcodes, 1)
        for s=sessions
            % Load file with experimental data.
            files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', ...
                parcodes(p,:), s));
            load(sprintf('expdata/%s', files(1).name));

            % Load eye tracking data.
            [time, ~, ~, item, ~] = ReadEyetrackingData(parcodes(p,:), s);

            for numBlock = 1:data.numBlocks
                angTarget = data.target(numBlock);
                for numTrial = 1:data.numTestTrials
                    if mod(numTrial,2) == 0 && oddTrialsOnly
                        continue;
                    end
                    if mod(numTrial,2) == 1 && evenTrialsOnly
                        continue;
                    end
                    if excludeByTimeLimit && ...
                            data.testTotalFixTime{numBlock}(numTrial) >= 3
                        continue;
                    end
                    distLeft = angTarget - data.left{numBlock}(numTrial);
                    distRight = angTarget - data.right{numBlock}(numTrial);
                    valueLeft(trial,1) = - abs(distLeft);
                    valueRight(trial,1) = - abs(distRight);
                    choice(trial,1) = ...
                        data.testResponseType{numBlock}(numTrial);
                    fixItem{trial,1} = item{numBlock,numTrial};
                    fixTime{trial,1} = time{numBlock,numTrial};
                    trial = trial + 1;
                end
            end
            fclose('all');
        end
    end
end

corrProbs = cell(length(timeBins), 1);

for trial=1:length(choice)
    % Get total fixation time for each item.
    timeLeftFix = 0;
    timeRightFix = 0;

    for i = 1:length(fixItem{trial})
        if fixItem{trial}(i) == 1 % left item fixation
            timeLeftFix = timeLeftFix + fixTime{trial}(i);
        elseif fixItem{trial}(i) == 2 % right item fixation
            timeRightFix = timeRightFix + fixTime{trial}(i);
        end
    end

    % Get time advantage bin.
    timeDiff = timeLeftFix - timeRightFix;
    bin = 1;
    for i=1:length(timeBins)-1
        if timeDiff >= timeBins(i) && timeDiff < timeBins(i+1)
            bin = i+1;
            break;
        end
    end
    if timeDiff >= timeBins(end)
        bin = length(timeBins);
    end
    
    % Get index based on value difference.
    vDiff = valueLeft(trial) - valueRight(trial);
    idx = find(valueDiffs==vDiff);
    
    % Check decision.
    if choice(trial) == -1 % choice was left
        prob = 1 - avgProbs(idx);
    elseif choice(trial) == 1 % choice was right
        prob = 0 - avgProbs(idx);
    end
    corrProbs{bin} = [corrProbs{bin}; prob];
end
end