function [countBiasedLongFix, countBiasedShortFix, countInvalid] = ...
    CountTrialsPerBiasedAndFixTime(parcode, session)

countBiasedLongFix = 0;
countBiasedShortFix = 0;
countInvalid = 0;

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));

for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        if data.testTotalFixTime{numBlock}(numTrial) >= 3
            countInvalid = countInvalid + 1;
            continue;
        end
        timeLeft = data.testFixTimeLeft{numBlock}(numTrial);
        timeRight = data.testFixTimeRight{numBlock}(numTrial);
        % Left was longer fixated.
        if timeLeft > timeRight
            % Left was biased.
            if data.biasedItem{numBlock}(numTrial) == 1
                countBiasedLongFix = countBiasedLongFix + 1;
            % Right was biased.
            elseif data.biasedItem{numBlock}(numTrial) == 2
                countBiasedShortFix = countBiasedShortFix + 1;
            end
        % Right was longer fixated.
        elseif timeRight > timeLeft
            % Right was biased.
            if data.biasedItem{numBlock}(numTrial) == 2
                countBiasedLongFix = countBiasedLongFix + 1;
            % Left was biased.
            elseif data.biasedItem{numBlock}(numTrial) == 1
                countBiasedShortFix = countBiasedShortFix + 1;
            end
        end
    end
end
end