function [fixTimesBiased, fixTimeUnbiased] = ...
    FixTimesWhenBiasedLongestFixated(parcodes, sessions)

fixTimesBiased = [];
fixTimeUnbiased = [];

for p=1:length(parcodes)
    for s=sessions
        % Load file with experimental data.
        files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', ...
            parcodes(p,:), s));
        load(sprintf('expdata/%s', files(1).name));
        fclose('all');

        for numBlock = 1:data.numBlocks
            for numTrial = 1:data.numTestTrials
                if data.testTotalFixTime{numBlock}(numTrial) >= 3
                    continue;
                end

                timeLeft = data.testFixTimeLeft{numBlock}(numTrial);
                timeRight = data.testFixTimeRight{numBlock}(numTrial);

                % Left was biased and longer fixated.
                if data.biasedItem{numBlock}(numTrial) == 1 && ...
                        timeLeft > timeRight
                    fixTimesBiased = [fixTimesBiased; timeLeft];
                    fixTimeUnbiased = [fixTimeUnbiased; timeRight];
                % Right was biased and longer fixated.
                elseif data.biasedItem{numBlock}(numTrial) == 2 && ...
                        timeRight > timeLeft
                    fixTimesBiased = [fixTimesBiased; timeRight];
                    fixTimeUnbiased = [fixTimeUnbiased; timeLeft];
                end
            end
        end
    end
end
end
