function avgProbs = GetAvgProbChooseLeftByValueDiff(valueDiffs, ...
    valueLeft, valueRight, choice, parcodes, sessions, oddTrialsOnly, ...
    evenTrialsOnly, excludeByTimeLimit)

if ~exist('oddTrialsOnly', 'var')
    oddTrialsOnly = false;
end
if ~exist('evenTrialsOnly', 'var')
    evenTrialsOnly = false;
end
if ~exist('excludeByTimeLimit', 'var')
    excludeByTimeLimit = false;
end

if exist('parcodes', 'var') && exist('sessions', 'var')
    trial = 1;
    for p=1:size(parcodes, 1)
        for s=sessions
            % Load file with experimental data.
            files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', ...
                parcodes(p,:), s));
            load(sprintf('expdata/%s', files(1).name));

            for numBlock = 1:data.numBlocks
                angTarget = data.target(numBlock);
                for numTrial = 1:data.numTestTrials
                    if mod(numTrial,2) == 0 && oddTrialsOnly
                        continue;
                    end
                    if mod(numTrial,2) == 1 && evenTrialsOnly
                        continue;
                    end
                    if excludeByTimeLimit && ...
                            data.testTotalFixTime{numBlock}(numTrial) >= 3
                        continue;
                    end
                    distLeft = angTarget - data.left{numBlock}(numTrial);
                    distRight = angTarget - data.right{numBlock}(numTrial);
                    valueLeft(trial,1) = - abs(distLeft);
                    valueRight(trial,1) = - abs(distRight);
                    choice(trial,1) = ...
                        data.testResponseType{numBlock}(numTrial);
                    trial = trial + 1;
                end
            end
            fclose('all');
        end
    end
end

countChoseLeft = zeros(length(valueDiffs),1);
countTotal = zeros(length(valueDiffs),1);
for trial=1:length(valueLeft)
    vDiff = valueLeft(trial) - valueRight(trial);
    idx = find(valueDiffs==vDiff);
    
    countTotal(idx) = countTotal(idx) + 1;
    if choice(trial) == -1 % choice was left
        countChoseLeft(idx) = countChoseLeft(idx) + 1;
    end
end
avgProbs = countChoseLeft ./ countTotal;

end