function [countChooseBiasedCorrect, countTotalBiasedCorrect, ...
    countChooseUnbiasedCorrect, countTotalUnbiasedCorrect, ...
    countChooseBiasedIncorrect, countTotalBiasedIncorrect, ...
    countChooseUnbiasedIncorrect, countTotalUnbiasedIncorrect, ...
    countChooseBiasedNeutral, countTotalBiasedNeutral] = ...
    ProbChooseBiased(parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));

countChooseBiasedCorrect = 0;
countTotalBiasedCorrect = 0;

countChooseUnbiasedCorrect = 0;
countTotalUnbiasedCorrect = 0;

countChooseBiasedIncorrect = 0;
countTotalBiasedIncorrect = 0;

countChooseUnbiasedIncorrect = 0;
countTotalUnbiasedIncorrect = 0;

countChooseBiasedNeutral = 0;
countTotalBiasedNeutral = 0;

for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        if data.testTotalFixTime{numBlock}(numTrial) >= 3
            continue;
        end
        angLeft = data.left{numBlock}(numTrial);
        valueLeft = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight = - abs(angTarget - angRight);
        % Left was correct.
        if valueLeft > valueRight
            % Left was biased.
            if data.biasedItem{numBlock}(numTrial) == 1
                countTotalBiasedCorrect = countTotalBiasedCorrect + 1;
                countTotalUnbiasedIncorrect = ...
                    countTotalUnbiasedIncorrect + 1;
                % Subject chose left.
                if data.testResponseType{numBlock}(numTrial) == -1
                    countChooseBiasedCorrect = ...
                        countChooseBiasedCorrect + 1;
                end
                % Subject chose right.
                if data.testResponseType{numBlock}(numTrial) == 1
                    countChooseUnbiasedIncorrect = ...
                        countChooseUnbiasedIncorrect + 1;
                end
            % Right was biased.
            elseif data.biasedItem{numBlock}(numTrial) == 2
                countTotalBiasedIncorrect = countTotalBiasedIncorrect + 1;
                countTotalUnbiasedCorrect = countTotalUnbiasedCorrect + 1;
                % Subject chose right.
                if data.testResponseType{numBlock}(numTrial) == 1
                    countChooseBiasedIncorrect = ...
                        countChooseBiasedIncorrect + 1;
                end
                % Subject chose left.
                if data.testResponseType{numBlock}(numTrial) == -1
                    countChooseUnbiasedCorrect = ...
                        countChooseUnbiasedCorrect + 1;
                end
            end
        % Right was correct.
        elseif valueRight > valueLeft
            % Left was biased.
            if data.biasedItem{numBlock}(numTrial) == 1
                countTotalBiasedIncorrect = countTotalBiasedIncorrect + 1;
                countTotalUnbiasedCorrect = countTotalUnbiasedCorrect + 1;
                % Subject chose left.
                if data.testResponseType{numBlock}(numTrial) == -1
                    countChooseBiasedIncorrect = ...
                        countChooseBiasedIncorrect + 1;
                end
                % Subject chose right.
                if data.testResponseType{numBlock}(numTrial) == 1
                    countChooseUnbiasedCorrect = ...
                        countChooseUnbiasedCorrect + 1;
                end
            % Right was biased.
            elseif data.biasedItem{numBlock}(numTrial) == 2
                countTotalBiasedCorrect = countTotalBiasedCorrect + 1;
                countTotalUnbiasedIncorrect = ...
                    countTotalUnbiasedIncorrect + 1;
                % Subject chose right.
                if data.testResponseType{numBlock}(numTrial) == 1
                    countChooseBiasedCorrect = ...
                        countChooseBiasedCorrect + 1;
                end
                % Subject chose left.
                if data.testResponseType{numBlock}(numTrial) == -1
                    countChooseUnbiasedIncorrect = ...
                        countChooseUnbiasedIncorrect + 1;
                end
            end
        else
            countTotalBiasedNeutral = countTotalBiasedNeutral + 1;
            % Left was biased.
            if data.biasedItem{numBlock}(numTrial) == 1
                % Subject chose left.
                if data.testResponseType{numBlock}(numTrial) == -1
                    countChooseBiasedNeutral = ...
                        countChooseBiasedNeutral + 1;
                end
            % Right was biased.
            elseif data.biasedItem{numBlock}(numTrial) == 2
                % Subject chose right.
                if data.testResponseType{numBlock}(numTrial) == 1
                    countChooseBiasedNeutral = ...
                        countChooseBiasedNeutral + 1;
                end
            end
        end
    end
end
end