function reactionTime = ReactionTimesByValueBestMinusWorst( ...
    nonNegativeValueDiffs, parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));

valueLeft = zeros(data.numBlocks * data.numTestTrials, 1);
valueRight = zeros(data.numBlocks * data.numTestTrials, 1);
rt = zeros(data.numBlocks * data.numTestTrials, 1);
trial = 1;
for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        angLeft = data.left{numBlock}(numTrial);
        valueLeft(trial,1) = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight(trial,1) = - abs(angTarget - angRight);
        rt(trial,1) = data.testReactionTime{numBlock}(numTrial) * 1000;
        trial = trial + 1;
    end
end
fclose('all');

reactionTime = cell(length(nonNegativeValueDiffs), 1);

for numTrial=1:length(rt)
    valueDiff = abs(valueLeft(numTrial) - valueRight(numTrial));
    idx = find(nonNegativeValueDiffs==valueDiff);
    reactionTime{idx} = [reactionTime{idx}; rt(numTrial)];
end
end
