function [timeAdvantageLeftBiasedLeft, timeAdvantageLeftBiasedRight] = ...
    TimeAdvantageLeftVsValueDiffGroupedByBiased(valueDiffs, ...
    parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));

valueLeft = zeros(data.numBlocks * data.numTestTrials, 1);
valueRight = zeros(data.numBlocks * data.numTestTrials, 1);
timeLeft = zeros(data.numBlocks * data.numTestTrials, 1);
timeRight = zeros(data.numBlocks * data.numTestTrials, 1);
biased = zeros(data.numBlocks * data.numTestTrials, 1);
trial = 1;
for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        if data.testTotalFixTime{numBlock}(numTrial) >= 3
            continue;
        end
        angLeft = data.left{numBlock}(numTrial);
        valueLeft(trial,1) = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight(trial,1) = - abs(angTarget - angRight);
        timeLeft(trial,1) = data.testFixTimeLeft{numBlock}(numTrial);
        timeRight(trial,1) = data.testFixTimeRight{numBlock}(numTrial);
        biased(trial,1) = data.biasedItem{numBlock}(numTrial);
        trial = trial + 1;
    end
end
fclose('all');

timeAdvantageLeftBiasedLeft = cell(length(valueDiffs), 1);
timeAdvantageLeftBiasedRight = cell(length(valueDiffs), 1);

for numTrial=1:length(timeLeft)
    if biased(numTrial) == 1 && timeLeft(numTrial) <= timeRight(numTrial)
        continue;
    elseif biased(numTrial) == 2 && timeLeft(numTrial) >= timeRight(numTrial)
        continue;
    end
        
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);
    timeAdvantage = (timeLeft(numTrial) - timeRight(numTrial)) * 1000;
    if biased(numTrial) == 1
        timeAdvantageLeftBiasedLeft{idx} = ...
            [timeAdvantageLeftBiasedLeft{idx}; timeAdvantage];
    elseif biased(numTrial) == 2
        timeAdvantageLeftBiasedRight{idx} = ...
            [timeAdvantageLeftBiasedRight{idx}; timeAdvantage];
    end
end
end
