function timeAdvantageLeft = TimeAdvantageLeftVsValueDifference( ...
    valueDiffs, parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));

% Load eye tracking data.
[fixTime, ~, ~, fixItem, ~, ~] = ReadEyetrackingData(parcode, session);
    
valueLeft = zeros(data.numBlocks * data.numTestTrials, 1);
valueRight = zeros(data.numBlocks * data.numTestTrials, 1);
timeLeft = zeros(data.numBlocks * data.numTestTrials, 1);
timeRight = zeros(data.numBlocks * data.numTestTrials, 1);
trial = 1;
for numBlock = 1:data.numBlocks
    angTarget = data.target(numBlock);
    for numTrial = 1:data.numTestTrials
        angLeft = data.left{numBlock}(numTrial);
        valueLeft(trial,1) = - abs(angTarget - angLeft);
        angRight = data.right{numBlock}(numTrial);
        valueRight(trial,1) = - abs(angTarget - angRight);
        
        for i=1:length(fixItem{numBlock,numTrial})
            if fixItem{numBlock,numTrial}(i) == 1
                timeLeft(trial,1) = timeLeft(trial,1) + ...
                    fixTime{numBlock,numTrial}(i);
            elseif fixItem{numBlock,numTrial}(i) == 2
                timeRight(trial,1) = timeRight(trial,1) + ...
                    fixTime{numBlock,numTrial}(i);
            end
        end
        trial = trial + 1;
    end
end
fclose('all');

timeAdvantageLeft = cell(length(valueDiffs), 1);

for numTrial=1:length(timeLeft)
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);
    timeAdvantage = timeLeft(numTrial) - timeRight(numTrial);
    timeAdvantageLeft{idx} = [timeAdvantageLeft{idx}; timeAdvantage];
end
end
