function [timeFixBiased, timeFixUnbiased] = ...
    TimeFixBiasedAndUnbiasedItems(parcode, session)

% Load file with experimental data.
files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
load(sprintf('expdata/%s', files(1).name));

timeLeft = zeros(data.numBlocks * data.numTestTrials, 1);
timeRight = zeros(data.numBlocks * data.numTestTrials, 1);
biased = zeros(data.numBlocks * data.numTestTrials, 1);
time = zeros(data.numBlocks * data.numTestTrials, 1);
trial = 1;
for numBlock = 1:data.numBlocks
    for numTrial = 1:data.numTestTrials
        timeLeft(trial,1) = data.testFixTimeLeft{numBlock}(numTrial);
        timeRight(trial,1) = data.testFixTimeRight{numBlock}(numTrial);
        biased(trial,1) = data.biasedItem{numBlock}(numTrial);
        time(trial,1) = data.testTotalFixTime{numBlock}(numTrial);
        trial = trial + 1;
    end
end
fclose('all');

timeFixBiased = [];
timeFixUnbiased = [];

for numTrial=1:length(timeLeft)
    if biased(numTrial) == 1
        if timeLeft(numTrial) <= timeRight(numTrial)
            continue;
        end
        if time(numTrial) >= 3
            continue;
        end
        timeFixBiased = [timeFixBiased; timeLeft(numTrial) * 1000];
        timeFixUnbiased = [timeFixUnbiased; timeRight(numTrial) * 1000];
    elseif biased(numTrial) == 2
        if timeRight(numTrial) <= timeLeft(numTrial)
            continue;
        end
        if time(numTrial) >= 3
            continue;
        end
        timeFixBiased = [timeFixBiased; timeRight(numTrial) * 1000];
        timeFixUnbiased = [timeFixUnbiased; timeLeft(numTrial) * 1000];
    end
end
end
