function trialDuration = TrialDurationFromEyetrackerByValueDiff( ...
    valueDiffs, duration, valueLeft, valueRight, parcode, session)

if exist('parcode', 'var') && exist('session', 'var')
    % Load file with experimental data.
    files = dir(sprintf('expdata/expdata_%s_s%d_*.mat', parcode, session));
    load(sprintf('expdata/%s', files(1).name));

    % Load eye tracking data.
    [~, ~, ~, ~, tDuration, ~] = ReadEyetrackingData(parcode, session);

    valueLeft = zeros(data.numBlocks * data.numTestTrials, 1);
    valueRight = zeros(data.numBlocks * data.numTestTrials, 1);
    duration = zeros(data.numBlocks * data.numTestTrials, 1);
    time = zeros(data.numBlocks * data.numTestTrials, 1);
    trial = 1;
    for numBlock = 1:data.numBlocks
        angTarget = data.target(numBlock);
        for numTrial = 1:data.numTestTrials
            angLeft = data.left{numBlock}(numTrial);
            valueLeft(trial,1) = - abs(angTarget - angLeft);
            angRight = data.right{numBlock}(numTrial);
            valueRight(trial,1) = - abs(angTarget - angRight);
            duration(trial,1) = tDuration(numBlock,numTrial);
            time(trial,1) = data.testTotalFixTime{numBlock}(numTrial);
            trial = trial + 1;
        end
    end
    fclose('all');
end

trialDuration = cell(length(valueDiffs), 1);

for numTrial=1:length(duration)
    if time(numTrial) >= 3
        continue;
    end
    valueDiff = valueLeft(numTrial) - valueRight(numTrial);
    idx = find(valueDiffs==valueDiff);
    trialDuration{idx} = [trialDuration{idx}; duration(numTrial)];
end
end
